define(['./_getTag', './isObjectLike'], function(getTag, isObjectLike) {

  'use strict';

  /** `Object#toString` result references. */
  var setTag = '[object Set]';

  /**
   * Checks if `value` is classified as a `Set` object.
   *
   * @static
   * @memberOf _
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
   * @example
   *
   * _.isSet(new Set);
   * // => true
   *
   * _.isSet(new WeakSet);
   * // => false
   */
  function isSet(value) {
    return isObjectLike(value) && getTag(value) == setTag;
  }

  return isSet;
});
